// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================


#include "seed.h"
#include "geometry.h"
#include "board.h"


extern Board* board;

// class of the seed on the board
// ----------------------------------------------------------------------------

// default constructor
Seed::Seed(void)
    :Shadow_Object()
{
    setGLArray(matAmbientAndDiff, f2vt(0.8), f2vt(0.5), f2vt(0.5));
    matShininess[0] = f2vt(40.0);
    setGLArray4(matSpecular, f2vt(1.0), f2vt(0.8), f2vt(0.8), f2vt(1.0));

    do
    {
        posX = (int) ((board->getSizeX() - 1) * (float) rand() / (float) RAND_MAX);
        posY = (int) ((board->getSizeY() - 1) * (float) rand() / (float) RAND_MAX);
    }
    while (!board->getCell(posX, posY)->isFree());
}

Seed::~Seed()
{
}

// get the position of the seed on the board
void Seed::getPos(int &seedX, int &seedY)
{
    seedX = posX;
    seedY = posY;
}

// display the seed
void Seed::display(void)
{
    glPushMatrix();

        myGlTranslate(f2vt(100.0 * this->posX), f2vt(100.0 * this->posY), 0);

        myGlTranslate(f2vt(50.0), f2vt(50.0), 0);

        // display the seed's shadow
        glPushMatrix();

            prepareShadow(30.0);

#ifdef USE_OPENGLES				
            mySolidSphere(30.0, 8, 10);
#else
            mySolidSphere(30.0, 16, 20);
#endif			

        glPopMatrix();

        // Draw Seed part
        prepareDisplay(30.0);

#ifdef USE_OPENGLES				
        mySolidSphere(30.0, 12, 12);
#else
        mySolidSphere(30.0, 20, 24);
#endif			

    glPopMatrix();
}
