// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef GLWIDGET_H
#define GLWIDGET_H

#include <QObject>
#include <QGLWidget>
#include <QTime>

#include "mainwindow.h"


class GLWidget : public QGLWidget {

    Q_OBJECT
private:
	MainWindow* mainWindow;
	void fixMotionRealtimeParams();

public:
    GLWidget(MainWindow* mainWindow = 0);
    virtual ~GLWidget();
    void motion(void);
    virtual void resizeGL(int width, int height);

    QSize sizeHint() const {
        return QSize(800, 600);
    };
 
    QSize minimumSizeHint() const {
        return QSize(640, 480);
    };

protected:
    void paintGL ();
    void initializeGL ();
};
#endif
