// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef SPOT_H_
#define SPOT_H_

#include "common.h"
#include "board.h"

// class of the spot
// ----------------------------------------------------------------------------
class Spot
{
private:

    // spot parameters
    MyGLReal lightSpecular[4];
    MyGLReal lightAmbient[4];
    MyGLReal lightDiffuse[4];

    MyGLReal lightCutoff;
    MyGLReal lightExponent;

    MyGLReal lightPosition[3];
    MyGLReal lightDirection[3];

    int spin;

public:

    // default constructor
    Spot(void);

    // initialize light parameters
    void initSpot(void);

    // position the spot
    void positionate(void);

    // get the spot position
    void getLightPosition(MyGLReal* lightPosition);

};

#endif /* SPOT_H_ */
