// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================


#include "shadow_object.h"

extern MyGLReal light0Shadow[4][4];

// default constructor
Shadow_Object::Shadow_Object(void)
              :Display_Object()
{
    init();
}

// constructor specifying the Display Object position
Shadow_Object::Shadow_Object(int x, int y)
              :Display_Object (x, y)
{
    init();
}

void Shadow_Object::init()
{
    shadowShininess[0] = f2vt(1.0);
    setGLArray4(shadowSpecular, f2vt(0.1), f2vt(0.1), f2vt(0.1), f2vt(1.0));
    setGLArray(shadowAmbientAndDiff, f2vt(0.1), f2vt(0.1), f2vt(0.1));
}

void Shadow_Object::prepareShadow(float translate)
{
    myGlMaterialv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, shadowAmbientAndDiff);
    myGlMaterialv(GL_FRONT_AND_BACK, GL_SHININESS, shadowShininess);
    myGlMaterialv(GL_FRONT_AND_BACK, GL_SPECULAR, shadowSpecular);

    myGlTranslate(0, 0, f2vt(1.0));
    myGlMultMatrix((MyGLReal *) light0Shadow);

    myGlTranslate(0, 0, f2vt(translate));
}

// destroyer
Shadow_Object::~Shadow_Object(void)
{
}
