// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QObject>
#include <QTimer>
#include <QKeyEvent>

class GLWidget;

class MainWindow : public QMainWindow
{
    Q_OBJECT

private:
    int sleepTime;
    QTimer *displayTimer;

public:
    MainWindow();
    ~MainWindow();
    void setNextSleepTime(int sleepTime);
    virtual void keyPressEvent(QKeyEvent* e);

public Q_SLOTS:
    void updateNavigation();
    void setModeAutopilot();
    void setModeManual();
    void switchPauseStart();
};

#endif
