// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// =============================================================================



#include "camera.h"

#include "engine.h"

extern Board* board;
extern Engine* engine;

// class of the camera
// ----------------------------------------------------------------------------

//constructor
Camera::Camera(void)
{
    setGLArray(position, f2vt(0.0 * board->getSizeX()), 0, f2vt(80.0 * board->getSizeX()));
    setGLArray(direction, 0, 0, 0);
    setGLArray(upVector, 0, f2vt(10.0), 0);

    spin = 0;
    doRotate = true;

    if (speedCoeffCam == 0.0)
    {
        speedCoeffCam = 1.0 / DISPLAY_EACH_SECOND * 20.0;
    }
}

// specify the value of a camera move increment
void Camera::saveCoeffValue(float coeff)
{
    speedCoeffCam = coeff;
}

// reinit camera
void Camera::init(void)
{
    speedCoeffCam = 1.0 / DISPLAY_EACH_SECOND * 20.0;
}

// start / stop camera rotation
void Camera::switchRotationOnOff(void)
{
    doRotate = !doRotate;
}

// position the camera
void Camera::positionate(void)
{
    double angle;

    MyGLReal positionTarget[3];
    MyGLReal upVectorTarget[3];

    if (engine->isManual())
    {
        
#ifdef USE_OPENGLES		

        spin = 0;

        positionTarget[0] = f2vt( (float) (cos(0.0) * 22.0) * (float) board->getSizeX());// + x;
        positionTarget[1] = f2vt(0);// (float) (sin(0.0) * 22.0) * (float) board->getSizeX());// + y;	
        positionTarget[2] = f2vt(65.0 * board->getSizeX());	

        upVectorTarget[0] = f2vt(-15.0 * (float) (cos(0.0)));
        upVectorTarget[1] = f2vt(-15.0 * (float) (sin(0.0)));
        upVectorTarget[2] = f2vt(0.0);		
#else

        spin = 270;
        angle = (MY_PI * (double) spin) / 180.0;

		positionTarget[0] = f2vt( (float) (cos(angle) * 30.0) * (float) board->getSizeX());// + x;
        positionTarget[1] = f2vt( (float) (sin(angle) * 30.0) * (float) board->getSizeX());// + y;	
        positionTarget[2] = f2vt(65.0 * board->getSizeX());		
		
        upVectorTarget[0] = f2vt(-14.0 * (float) (cos(angle)));
        upVectorTarget[1] = f2vt(-14.0 * (float) (sin(angle)));
        upVectorTarget[2] = 0;		
#endif

    }
    else
    {
        if (doRotate)
        {
            spin += speedCoeffCam / 3;

            if (spin > 360)
            {
                spin = 0;
            }
        }

        // angle in radian =
        angle = (MY_PI * (double) spin) / 180.0;

        positionTarget[0] = f2vt( (float) (cos(angle) * 60.0) * (float) board->getSizeX());// + x;
        positionTarget[1] = f2vt( (float) (sin(angle) * 60.0) * (float) board->getSizeX());// + y;
        positionTarget[2] = f2vt(80.0 * board->getSizeX());

        upVectorTarget[0] = f2vt(-10.0 * (float) (cos(angle)));
        upVectorTarget[1] = f2vt(-10.0 * (float) (sin(angle)));
        upVectorTarget[2] = 0;
    }

    position[0] = f2vt((50.0 * vt2f(position[0]) + vt2f(positionTarget[0])) / 51.0);
    position[1] = f2vt((50.0 * vt2f(position[1]) + vt2f(positionTarget[1])) / 51.0);
    position[2] = f2vt((50.0 * vt2f(position[2]) + vt2f(positionTarget[2])) / 51.0);

    upVector[0] = f2vt((50.0 * vt2f(upVector[0]) + vt2f(upVectorTarget[0])) / 51.0);
    upVector[1] = f2vt((50.0 * vt2f(upVector[1]) + vt2f(upVectorTarget[1])) / 51.0);
    upVector[2] = f2vt((50.0 * vt2f(upVector[2]) + vt2f(upVectorTarget[2])) / 51.0);

    myGluLookAt(position[0], position[1], position[2], direction[0],
            direction[1], direction[2], upVector[0], upVector[1],
            upVector[2]);

}

// reshape the camera
void Camera::reshape(GLsizei width, GLsizei height)
{

    glViewport(0, 0, width, height);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();

    myGlFrustum(f2vt(-40.0 * board->getSizeX()), f2vt(40.0 * board->getSizeX()), f2vt(-45 * board->getSizeY()),
                f2vt( 30.0 * board->getSizeY()), f2vt(40.0 * board->getSizeX()), f2vt(150.0 * board->getSizeX()));

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}

