// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#include "body_part.h"
#include "geometry.h"


// class of a element of the body
// ----------------------------------------------------------------------------

// constructor : fix initial position
Body_Part::Body_Part(void)
    :Shadow_Object()
{
	number = -1;
    matShininess[0] = f2vt(80.0);
    setGLArray4(matSpecular, f2vt(0.2), f2vt(0.3), f2vt(0.4), f2vt(1.0));
    setGLArray(matAmbientAndDiff, f2vt(0.1), f2vt(0.2), f2vt(0.3));
}

Body_Part::~Body_Part()
{
}

// fix original position of the body part
void Body_Part::setOrigin(int x, int y, int no)
{
    this->setPosition(x, y);
    this->number = no;
}

// Display the body part
void Body_Part::display(void)
{

    glPushMatrix();

        myGlTranslate(f2vt(50.0), f2vt(50.0), 0);

        // draw shadow
        glPushMatrix();

        	prepareShadow(50.0);

#ifdef USE_OPENGLES
            mySolidSphere(60.0, 10, 10);
#else
            mySolidSphere(60.0, 20, 20);
#endif            

        glPopMatrix();

        // draw the body part
        prepareDisplay(50.0);
        
#ifdef USE_OPENGLES        
        mySolidSphere(60.0, 16, 16);
#else
        mySolidSphere(60.0, 36, 36);
#endif

    glPopMatrix();
}

