// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#include "board.h"
#include "geometry.h"


// Class of the game board
// ----------------------------------------------------------------------------

// constructor, proceed with board initialization
Board::Board(int x, int y)
{
    // __NEW__
        groundShininess[0] = f2vt(20.0);
        setGLArray4(groundSpecular, f2vt(1.0), f2vt(1.0), f2vt(1.0), f2vt(1.0));
        setGLArray(groundAmbientAndDiff, f2vt(0.3), f2vt(0.6), f2vt(0.6));

    seed = NULL;
		
    sizeX = x;
    sizeY = y;

    // create the array
    cells = new Cell**[x];
    for (int i = 0; i < x; i++)
    {
        cells[i] = new Cell*[y];
        // create the cells
        for (int j = 0; j < y; j++)
            cells[i][j] = new Cell(i, j);
    }

    seed = NULL;
}

// reinitialize
void Board::init(void)
{
    // reinit the cells
    for (int i = 0; i < sizeX; i++)
        for (int j = 0; j < sizeY; j++)
            cells[i][j]->setFree();
}

void Board::resetAllCellsHighlights()
{
    // reinit the cells highlights
    for (int i = 0; i < sizeX; i++)
        for (int j = 0; j < sizeY; j++)
            cells[i][j]->resetHighlight();
}

// Destroyer, delete cells
Board::~Board(void)
{
    // destroy cells
    for (int i = 0; i < sizeX; i++)
        for (int j = 0; j < sizeY; j++)
            delete cells[i][j];

    // destroy array
    delete[] cells;
}

// Create a random seed on the board
void Board::createRandomSeed(void)
{
    if (seed != NULL)
    {
        delete seed;
    }
    seed = new Seed();
}

// get the position of the seed on the board
void Board::getSeedPos(int &seedX, int &seedY)
{
    seed->getPos(seedX, seedY);
}

Cell* Board::getSeedCell()
{
    int seedX, seedY;
    seed->getPos(seedX, seedY);
    return this->getCell(seedX, seedY);
}

std::list<Cell*>* Board::getCellList()
{
    std::list<Cell*>* allCells = new std::list<Cell*>();

    for (int i = 0; i < sizeX; i++)
        for (int j = 0; j < sizeY; j++)
            allCells->push_back(cells[i][j]);

    return allCells;
}

// compare given position with the one of the seed
bool Board::matchesSeedCell(int x, int y)
{
    int seedX, seedY;
    seed->getPos(seedX, seedY);
    return (x == seedX && y == seedY);
}

// display the world
void Board::display(void)
{
    // __NEW__
    glPushMatrix();
        // draw the parcel square
        myGlMaterialv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, groundAmbientAndDiff);
        myGlMaterialv(GL_FRONT_AND_BACK, GL_SHININESS, groundShininess);
        myGlMaterialv(GL_FRONT_AND_BACK, GL_SPECULAR, groundSpecular);

        drawBigSquare();
    glPopMatrix();

    // display cells
    for (int i = 0; i < this->sizeX; i++)
        for (int j = 0; j < this->sizeY; j++)
            cells[i][j]->display();

    // display seed
    seed->display();
}

int Board::getSizeX()
{
    return this->sizeX;
}

int Board::getSizeY()
{
    return this->sizeY;
}

Cell* Board::getCell (int x, int y)
{
    return this->cells[x][y];
}
