// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#include "mainwindow.h"

#include <QApplication>
#include <QMenuBar>
#include <QGroupBox>
#include <QGridLayout>
#include <QSlider>
#include <QLabel>
#include <QTimer>

#include "glwidget.h"
#include "engine.h"

extern Engine* engine;
extern Worm* worm;
extern void keyboard(unsigned char key, int x, int y);

MainWindow::MainWindow()
{
	this->setWindowTitle(WINDOW_TITLE);

	this->sleepTime = 200;

    GLWidget *glwidget = new GLWidget(this);
    displayTimer = new QTimer(this);

    displayTimer->setInterval(this->sleepTime);

    QGroupBox * groupBox = new QGroupBox(this);
    setCentralWidget(groupBox);
    groupBox->setStyleSheet("border: 0; ");

    QGridLayout *layout = new QGridLayout(groupBox);

    layout->addWidget(glwidget,0,0);;//,8,1);

    groupBox->setLayout(layout);
    groupBox->setFlat(true);

    QMenu *snakeMenu = new QMenu();

    QAction *autopilot = new QAction("Auto", snakeMenu);
    QAction *manual = new QAction("Manual", snakeMenu);
    QAction *exit = new QAction("Exit", snakeMenu);
    QAction *pauseStart = new QAction("Pause/Start", snakeMenu);

    snakeMenu->addAction(exit);
    snakeMenu->addAction(autopilot);
    snakeMenu->addAction(manual);
    snakeMenu->addAction(pauseStart);

    menuBar()->addMenu(snakeMenu);

    QObject::connect(exit, SIGNAL(triggered(bool)), this, SLOT(close()));
    QObject::connect(autopilot, SIGNAL(triggered(bool)), this, SLOT(setModeAutopilot()));
    QObject::connect(manual, SIGNAL(triggered(bool)), this, SLOT(setModeManual()));
    QObject::connect(pauseStart, SIGNAL(triggered(bool)), this, SLOT(switchPauseStart()));

    QObject::connect(displayTimer, SIGNAL(timeout()), glwidget, SLOT(updateGL()));

    displayTimer->start();
}

MainWindow::~MainWindow()
{
    displayTimer->stop();

    delete displayTimer;

}

void MainWindow::keyPressEvent(QKeyEvent* e) {

	// need to translate keys unfortunately
    switch (e->key()) {
    case Qt::Key_Escape:
    	keyboard (27, 0, 0);
        break;
    case Qt::Key_P:
    	keyboard ('p', 0, 0);
        break;
    case Qt::Key_S:
    	keyboard ('s', 0, 0);
        break;
    case Qt::Key_O:
    	keyboard ('o', 0, 0);
        break;
    case Qt::Key_H:
    case Qt::Key_Left:
    	keyboard ('h', 0, 0);
        break;
    case Qt::Key_K:
    case Qt::Key_Right:
    	keyboard ('k', 0, 0);
        break;
    case Qt::Key_U:
    case Qt::Key_Up:
    	keyboard ('u', 0, 0);
        break;
    case Qt::Key_J:
    case Qt::Key_Down:
    	keyboard ('j', 0, 0);
        break;
    }

}

void MainWindow::setNextSleepTime(int sleepTime)
{
	this->sleepTime = sleepTime;
	//printf ("New sleep time %d\n", sleepTime);
	//fflush(stdout);
	displayTimer->setInterval(sleepTime);
}

void MainWindow::updateNavigation()
{
    if (menuBar()->isHidden())
    {
        //navigation->update();
    }
}

void MainWindow::setModeAutopilot()
{
    worm->run();
    engine->setAutopilot();
}

void MainWindow::setModeManual()
{
    worm->pause();
    engine->setManual();
}

void MainWindow::switchPauseStart()
{
    worm->switchPause();
}
