// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================




#ifdef USE_OPENGLES
#define QT_OPENGL_ES_1
#else
#undef QT_OPENGL_ES_1
#undef QT_OPENGL_ES_2
#define QT_OPENGL
#endif



#include "glwidget.h"

#include "common.h"

#include "engine.h"
#include "camera.h"
#include "worm.h"
#include "cell.h"
#include "board.h"
#include "spot.h"
#include "head.h"
#include "body_part.h"


#include <math.h>



// motion management
extern unsigned long startTime;
extern unsigned long displayTime;

extern int screenResX;
extern int screenResY;

extern void initializeGLImpl();
extern void gameMotion();
extern void displayGame();
extern unsigned long getMotionRealtimeSleepTime();


GLWidget::GLWidget(MainWindow* mainWindow)
    : QGLWidget(mainWindow)
{
	this->mainWindow = mainWindow;
	
/*
	setAttribute(Qt::WA_PaintOnScreen);
	setAttribute(Qt::WA_NoSystemBackground);
*/
	
    setAutoBufferSwap(false);
}

GLWidget::~GLWidget()
{
}

void GLWidget::initializeGL ()
{
    initializeGLImpl();
}

void GLWidget::fixMotionRealtimeParams()
{
    unsigned long sleepTime = getMotionRealtimeSleepTime();

    //printf("Sleeping %lu ms  \n", sleep_time);

    if(sleepTime != 0)
    {
        //usleep(sleep_time * 1000);
    	this->mainWindow->setNextSleepTime (sleepTime);
    }
}


void GLWidget::motion(void)
{
    this->fixMotionRealtimeParams();

    gameMotion();
}

void GLWidget::resizeGL(int width, int height)
{
    screenResX = width;
    screenResY = height;
}

void GLWidget::paintGL()
{
	this->motion();

	displayGame();

    // important !!!
    glFlush();
    swapBuffers();

    unsigned long end_time = getTime();
    displayTime = end_time - startTime;

}
