// ============================================================================
//
// Copyright (c) (double), niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



// common stuff

#ifndef COMMON_H
#define COMMON_H

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <math.h>
#include <vector>
#include <list>

#include <iostream>

#include <string>
#include <map>
#include <limits>

#include <set>


#define DEBUG

#ifdef _WIN32
#include <windows.h>
#else
#include <curses.h>
#endif

#ifdef USE_OPENGLES
#include "GLES/gl.h"
#else
#include "GL/gl.h"
#endif

#ifdef USE_GLUT
#include "GL/glu.h"
#include "GL/glut.h"
#endif


#define WINDOW_TITLE "Snake - by Jerome Kehrli (2010-2016)"

#define OFFSET_RANGE 100

#define BOARD_SIZE 18

#define SCREEN_RES_X 800
#define SCREEN_RES_Y 600

#define MY_PI 3.14159265358979323846

#ifdef USE_OPENGLES
#define DISPLAY_EACH_SECOND 10
#define WORM_INITIAL_SPEED_OFFSET 15
#else
#define DISPLAY_EACH_SECOND 50
#define WORM_INITIAL_SPEED_OFFSET 5
#endif


typedef enum {DIR_UP, DIR_LEFT, DIR_DOWN, DIR_RIGHT} direction_t ;

typedef struct action_temp* action_ptt;

typedef struct action_temp
{
  action_ptt next;
  direction_t dir;
} action_tp;

#define DOUBLE_MAX_VALUE 99999999.0

class Cell;

typedef Cell* vertex_t;
typedef double weight_t;

struct edge {
    vertex_t target;
    weight_t weight;
    edge(vertex_t argTarget, weight_t argWeight)
        : target(argTarget), weight(argWeight) { }
};

typedef std::map<vertex_t, std::list<edge> > adjacency_map_t;

template <typename T1, typename T2>
struct pair_first_less
{
    bool operator()(std::pair<T1,T2> p1, std::pair<T1,T2> p2) const
    {
       if(p1.first == p2.first)
       {
          //Otherwise the initial vertex_queue will have the size 2 { 0,source ; inf;n }
          return p1.second < p2.second;
       }
       return p1.first < p2.first;
    }
};


unsigned long getTime(void);


// Custom OpenGL types to adapt (if required) to ES specific types
#ifdef USE_OPENGLES

#define FLOAT2X(f)      ((int) ( (f) * (65536.0f)))
#define X2FLOAT(x)      ((float)(x) / (65536.0f))

#define f2vt(f)     FLOAT2X(f)
#define vt2f(x)     X2FLOAT(x)

#define MyGLReal GLfixed
#define MY_GL_REAL GL_FIXED

#define myGlFog             glFogx
#define myGlFogv            glFogxv

#define myGlLight           glLightx
#define myGlLightv          glLightxv
#define myGlLightModel      glLightModelx
#define myGlLightModelv     glLightModelxv

#define myGlAlphaFunc       glAlphaFuncx

#define myGlMaterial        glMaterialx
#define myGlMaterialv       glMaterialxv
#define myGlColor4          glColor4x

#define myGlTexParameter    glTexParameterx
#define myGlTexEnv          glTexEnvx

#define myGlOrtho           glOrthox
#define myGlFrustum         glFrustumx

#define myGlTranslate       glTranslatex
#define myGlScale           glScalex
#define myGlRotate          glRotatex
#define myGlLoadMatrix      glLoadMatrixx

#define myGlClearColor      glClearColorx

#define myGlMultMatrix      glMultMatrixx

#define myGlNormal3         glNormal3x

#define myGlPolygonOffset   glPolygonOffsetx
#define myGlPointSize       glPointSizex


#else

// Or plain normal fat OpenGL type

#define f2vt(f)     (f)
#define vt2f(x)     (x)

#define MyGLReal GLfloat
#define MY_GL_REAL GL_FLOAT

#define myGlFog             glFogf
#define myGlFogv            glFogfv

#define myGlLight           glLightf
#define myGlLightv          glLightfv
#define myGlLightModel      glLightModelf
#define myGlLightModelv     glLightModelfv

#define myGlAlphaFunc       glAlphaFuncf

#define myGlMaterial        glMaterialf
#define myGlMaterialv       glMaterialfv
#define myGlColor4          glColor4f

#define myGlTexParameter    glTexParameterf
#define myGlTexEnv          glTexEnvf

#define myGlOrtho           glOrthof
#define myGlFrustum         glFrustum

#define myGlTranslate       glTranslatef
#define myGlScale           glScalef
#define myGlRotate          glRotatef
#define myGlLoadMatrix      glLoadMatrixf

#define myGlClearColor      glClearColor

#define myGlMultMatrix      glMultMatrixf

#define myGlNormal3         glNormal3f

#define myGlPolygonOffset   glPolygonOffsetf
#define myGlPointSize       glPointSizef

#endif


#endif
