// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#include "spot.h"

extern Board* board;

// spot class
// ----------------------------------------------------------------------------

// default constructor
Spot::Spot(void)
{
	setGLArray4(lightSpecular, f2vt(1.0), f2vt(1.0), f2vt(1.0), f2vt(1.0));
	setGLArray4(lightAmbient, f2vt(0.4), f2vt(0.4), f2vt(0.4), f2vt(1.0));
	setGLArray4(lightDiffuse, f2vt(1.0), f2vt(1.0), f2vt(1.0), f2vt(1.0));

    lightCutoff = f2vt(20.0);
    lightExponent = f2vt(30.0);

    setGLArray(lightPosition, f2vt(0.0), f2vt(0.0), f2vt(25.0 * board->getSizeX()));
    setGLArray(lightDirection, 0, 0, f2vt(-10.0));

    spin = 0;
}

// initialize light parans
void Spot::initSpot(void)
{
    myGlLightv(GL_LIGHT0, GL_AMBIENT, lightAmbient);
    myGlLightv(GL_LIGHT0, GL_DIFFUSE, lightDiffuse);
    myGlLightv(GL_LIGHT0, GL_SPECULAR, lightSpecular);
    myGlLight(GL_LIGHT0, GL_SPOT_CUTOFF, lightCutoff);
    myGlLight(GL_LIGHT0, GL_SPOT_EXPONENT, lightExponent);
    myGlLight(GL_LIGHT0, GL_LINEAR_ATTENUATION, f2vt(5.0));
}

// get spot position
void Spot::getLightPosition(MyGLReal* light_pos)
{
    light_pos[0] = lightPosition[0];
    light_pos[1] = lightPosition[1];
    light_pos[2] = lightPosition[2];
}

// position the spot
void Spot::positionate(void)
{
    myGlLightv(GL_LIGHT0, GL_POSITION, lightPosition);
    myGlLightv(GL_LIGHT0, GL_SPOT_DIRECTION, lightDirection);
}
