// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef SHADOW_OBJECT_H_
#define SHADOW_OBJECT_H_


#include "common.h"
#include "geometry.h"
#include "display_object.h"


// Class of a object having a shadow
class Shadow_Object : public Display_Object
{

private:
    void init();

protected:

    MyGLReal shadowShininess[1];
    MyGLReal shadowSpecular[4];
    MyGLReal shadowAmbientAndDiff[3];

    void prepareShadow(float translate);

public:

    // default constructor
    Shadow_Object(void);

    Shadow_Object(int x, int y);

    // destructor
    virtual ~Shadow_Object(void);

};



#endif /* SHADOW_OBJECT_H_ */
