// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================

#include "head.h"
#include "geometry.h"

// class of the head of the worm
// ----------------------------------------------------------------------------

// default constructor
Head::Head(void)
    :Shadow_Object()
{
    matShininess[0] = f2vt(30.0);
    setGLArray4(matSpecular, f2vt(0.3), f2vt(0.4), f2vt(0.5), f2vt(1.0));
    setGLArray(matAmbientAndDiff, f2vt(0.1), f2vt(0.2), f2vt(0.4));
}

Head::~Head()
{
}

// display the head
void Head::display(void)
{

    glPushMatrix () ;

        myGlTranslate(f2vt(50.0), f2vt(50.0), 0);

        // draw shadow
        glPushMatrix();

            prepareShadow(50.0);
            
#ifdef USE_OPENGLES
            mySolidSphere(60.0, 10, 10);
#else
            mySolidSphere(60.0, 20, 20);
#endif            

        glPopMatrix();

        //glDisableClientState(GL_COLOR_ARRAY);

        // Draw head part
        prepareDisplay(50.0);

#ifdef USE_OPENGLES        
        mySolidSphere(60.0, 16, 16);
#else
        mySolidSphere(60.0, 36, 36);
#endif        

    glPopMatrix();

}
