// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef GEOMETRY_H_
#define GEOMETRY_H_

#include "common.h"

void setGLArray (MyGLReal*, MyGLReal, MyGLReal, MyGLReal);

void setGLArray4 (MyGLReal* tab, MyGLReal red, MyGLReal green, MyGLReal blue, MyGLReal alpha);

void computeNormalVector (MyGLReal* point_1 , MyGLReal* point_2 , MyGLReal* point_3 , MyGLReal norm[3]);

void drawSquare (void);

void drawLittleSquare (void);

void drawBigSquare (void);

void shadowMatrixCalc(MyGLReal shadow_mat[4][4], float ground_plane[4], MyGLReal light_pos[4]);

void findPlane(float plane[4], float v0[3], float v1[3], float v2[3]);

void myGluLookAt(MyGLReal eyeX, MyGLReal eyeY, MyGLReal eyeZ, float lookAtX,
        float lookAtY, float lookAtZ, float upX, float upY, float upZ);

void mySolidTorus(float ir, float oor, GLint sides, GLint rings);

void mySolidBox(MyGLReal Width, MyGLReal Depth, MyGLReal Height);

void myWireBox(MyGLReal Width, MyGLReal Depth, MyGLReal Height);

void mySolidSphere(float radius, GLint slices, GLint stacks);

void myWireSphere(float radius, GLint slices, GLint stacks);

void mySolidCone(float base, float height, GLint slices, GLint stacks);

void mySolidCube(float size);

void myWireCube(float size);

#endif /* GEOMETRY_H_ */

