// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef ENGINE_H
#define ENGINE_H

#include "common.h"
#include "board.h"
#include "worm.h"


// navigation engine class
// ----------------------------------------------------------------------------
class Engine
{
private:

    direction_t getDumbDirection(void);

    //int countCellsInPath(Cell* current, int prevCount, bool** cellMarks);

    bool activ; // ON/OFF

    direction_t askedDirection;

public:

    // default constructor
    Engine(void);

    // reinitialize navigation engine
    void init(void);

    // Used to get the next action
    direction_t getNext(void);

    // turn auto-pilot on/off
    void switchEngineOnOff(void);
    void setAutopilot(void);
    void setManual(void);

    void setAskedDirection (direction_t asked_direction);

    direction_t getAskedDirection(void);

    bool isManual();

    bool** buildReachableCellsMarkerMarkers(Cell* optionalCandidate = NULL);
};

#endif
