// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================


#include "display_object.h"


// default constructot
Display_Object::Display_Object(void)
{
	direction = DIR_UP;
    posX = -1;
    posY = -1;
}

// constructor specifying the Display Object position
Display_Object::Display_Object(int x, int y)
{
	direction = DIR_UP;
    posX = x;
    posY = y;
}

// destroyer
Display_Object::~Display_Object(void)
{
}


// fix Display Object position
void Display_Object::setPosition(int x, int y)
{
    posX = x;
    posY = y;
}

// get the position of the Display Object
void Display_Object::getPosition(int &x, int &y)
{
    x = posX;
    y = posY;
}

// get the direction
direction_t Display_Object::getDirection(void)
{
    return direction;
}

// set direction
void Display_Object::setDirection(direction_t dir)
{
    direction = dir;
}

void Display_Object::prepareDisplay(float translate)
{
    myGlMaterialv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, matAmbientAndDiff);
    myGlMaterialv(GL_FRONT_AND_BACK, GL_SHININESS, matShininess);
    myGlMaterialv(GL_FRONT_AND_BACK, GL_SPECULAR, matSpecular);

    myGlTranslate(0, 0, f2vt(translate));
}

