// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef CELL_H_
#define CELL_H_

#include "common.h"
#include "geometry.h"
#include "display_object.h"

// Class of a cell of the game board
class Cell : public Display_Object
{

private:

    bool free; // whether the cell is free of not at the current moment in time

    bool highlighted;

    // color parameters
    // __NEW__
        MyGLReal groundShininess[1];
        MyGLReal groundSpecular[4];
        MyGLReal groundAmbientAndDiff[3];

    int cost;

    int __computeCost_internal();

	bool hasPartition(bool useThis);

	void printReachableCellsMarker (bool useThis);

public:

    // default constructor
    Cell();

    // destructor
    virtual ~Cell(void);

    // constructor taking as argument the position of the cell
    Cell(int x, int y);

    // --------------------------------------------------------------
    bool isFree(void); // returns true of the cell is free

    void setFree(void); // mark the cell as free

    void setUsed(void); // mark the cell as busy
    // --------------------------------------------------------------

    // display the cell
    void display(void);

    direction_t getCellDirection(Cell* cell);

    std::vector<Cell*>* getNeighbours();

    void highlightDarker();
    void highlightDark();
    void highlight();
    void highlightLight();
    void highlightLighter();

    void resetHighlight();

    int getCost();

    void computeCost();

};

#endif
