// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef WORM_H_
#define WORM_H_

#include "common.h"

#include "board.h"
#include "head.h"
#include "body_part.h"
#include "engine.h"

// class of the worm
// ----------------------------------------------------------------------------

class Worm
{

private:

    bool running;

    int bodyPartCount; // current number of elements (head exluded)

    int offset; // the current offset related to the begining of the cells
    // (When exceeds the max offset, the worm has moved to the next
    // cell)

    // constituents
    Head head; // the head
    Body_Part* body; // the body parts

    float speedCoeffWorm;

    int initX, initY;

    direction_t initDirection;

    void moveHead(int nextPositionX, int nextPositionY,
            bool & quit, int headX, int headY);

public:

    // Fix the worm speed increment FIXME rename me
    void fixeCoeff(float coeff);

    // constructor : fix initial position of the head
    Worm(int x, int y, direction_t dir);

    // initialize the worm
    void init(void);

    // destructor (destroys dynamic elements)
    ~Worm();

    void move(void); // Make the worm move ahead one unit of distance

    // add a body part to the worm
    void addBodyPart(int headX, int headY);

    bool moveCell(void);// register new directions
    // (returns false in case of crahs or our of bounds)

    // aks the worm for the new direction
    void setDirection(direction_t dir);

    // get the position of the worm's head
    void getHeadPosition(int &headX, int &headY);

    int getOffset(void); // used to know the current offset

    // used to get the number of body parts
    int getBodyPartCount(void);

    // Get the direction of the head
    direction_t getDirection(void);

    void display(void); // display the worm

    int getNearBodyPartCount(int posX, int posY);

    void run(void);

    void pause(void);

    void switchPause(void);
};

#endif
