// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef DISPLAY_OBJECT_H_
#define DISPLAY_OBJECT_H_


#include "common.h"



// Class of a object being anyhow displayed in the world
class Display_Object
{

protected:

    direction_t direction; // each cell has a direction associated to it. This is how the worm moves.
    // The head sets the direction and the body elements follow

    // inherited color parameters
    MyGLReal matShininess[1];
    MyGLReal matSpecular[4];
    MyGLReal matAmbientAndDiff[3];

    int posX; // cell position on the board
    int posY;

    void prepareDisplay(float translate);

public:

    // default constructor
    Display_Object(void);

    // destructor
    virtual ~Display_Object(void);

    // constructor taking as argument the position of the display object
    Display_Object(int x, int y);

    void setPosition(int x, int y); // fix the object position

    void getPosition(int &x, int &y); // get the object potition

    direction_t getDirection(void); // get the direction

    void setDirection(direction_t dir); // set the direction

    // display the object
    virtual void display(void) = 0;

};



#endif /* DISPLAY_OBJECT_H_ */
