// ============================================================================
//
// Copyright (c) 2010, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================


#include "common.h"


unsigned long getTime(void)
{

#ifdef _WIN32

    SYSTEMTIME* myTime = new SYSTEMTIME;
    GetSystemTime (myTime);

    return
		myTime->wHour * 1000 * 60 * 60 +
		myTime->wMinute * 1000 * 60 +
		myTime->wSecond * 1000 +
		myTime->wMilliseconds;

#else

    timespec tp;
    int retValueClockGettime;
    if ((retValueClockGettime = clock_gettime(CLOCK_REALTIME, &tp)))
    {
        printf("Got error when calling clock_gettime : %d\n",
                retValueClockGettime);
        exit(-1);
    }
    return tp.tv_sec * 1000 + tp.tv_nsec / 1000000;

#endif
}


