// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef CAMERA_H_
#define CAMERA_H_

#include "common.h"
#include "geometry.h"
#include "board.h"

// class of the camera
// ----------------------------------------------------------------------------
class Camera
{
private:

    MyGLReal position[3]; // the position
    MyGLReal direction[3]; // the target direction
    MyGLReal upVector[3]; // the vector ...

    float spin; // ...

    bool doRotate; // whether the camera should rotate or not

    float speedCoeffCam;

    // to set the movement speed coeff
    void saveCoeffValue(float coeff);

public:

    // default constructor
    Camera(void);

    // reinitialize the camera
    void init(void);

    // position the camera
    void positionate(void);

    // start or stop the camera rotation
    void switchRotationOnOff(void);

    // define the camera
    void reshape(GLsizei width, GLsizei height);
};

#endif
