// ============================================================================
//
// Copyright (c) 2010-2016, niceideas.ch - Jerome Kehrli
//
// You may distribute this code under the terms of the GNU LGPL license
// (http://www.gnu.org/licenses/lgpl.html). [^]
//
// ============================================================================



#ifndef BOARD_H_
#define BOARD_H_

#include <list>

#include "common.h"
#include "cell.h"
#include "seed.h"

// class of the game board
// ----------------------------------------------------------------------------
class Board
{
private:

    int sizeX; // board size
    int sizeY;

    Cell*** cells; // board cells

    Seed* seed;

    // __NEW__
    MyGLReal groundShininess[1];
    MyGLReal groundSpecular[4];
    MyGLReal groundAmbientAndDiff[3];

public:

    // proceed to the board initialization
    Board(int x, int y);
    // (initializes the dynamic array and the cells)

    // reinit
    void init(void);

    // destructor, delete the board cells
    ~Board(void);

    // Create a new seed
    void createRandomSeed(void);

    // Get the seed position
    void getSeedPos(int &seed_x, int &seed_y);

    Cell* getSeedCell();

    std::list<Cell*>* getCellList();

    // Compare given position with the seed's position
    bool matchesSeedCell(int x, int y);
    // (returns true of both position matches)

    // display the board
    void display(void);

    int getSizeX();
    int getSizeY();

    Cell* getCell (int x, int y);

    void resetAllCellsHighlights();

};

#endif /* BOARD_H_ */
